# 🚀 VPS Deployment Session - November 15, 2025

**Time**: 7:00 PM - 7:31 PM UTC+01:00  
**Objective**: Deploy admin and customer apps to VPS with new domain structure  
**Status**: IN PROGRESS

---

## 📌 New Architecture Confirmed

### **Domains:**
- **Backend API**: `www.catalogquienquillerie.sqb-tunisie.com` (Port 3001)
- **Admin Dashboard**: `sqb-tunisie.com/admin`
- **Customer Shop**: `sqb-tunisie.com/customer`

### **Key Decision:**
- ❌ No longer using Netlify
- ✅ Full VPS deployment with custom domains
- ✅ Manual deployment approach (not automated script)

---

## ✅ Completed Steps

### **Step 1: Pull Latest Code** ✅
```bash
cd /home/cube/Documents/theBricoHouse/UpdatedCatalog/project-20251027T071334Z-1-001/SmarTcataloGue_Update/smartCatalogVersion015/SmartCatalogueproject
git pull origin main
```
**Result**: Already up to date

### **Step 2: Create Production Environment Files** ✅
```bash
# Customer shop
echo 'VITE_API_URL=https://www.catalogquienquillerie.sqb-tunisie.com/api' > .env.production

# Admin dashboard
echo 'VITE_API_URL=https://www.catalogquienquillerie.sqb-tunisie.com/api' > admin-dashboard/.env.production
```
**Result**: Environment files created with correct API URL

### **Step 3: Build Customer Shop** ✅
```bash
npm install
npm run build
```
**Result**: 
- Build successful
- Output: `dist/` folder created
- Size: 289.17 kB (gzipped: 78.37 kB)
- Files: index.html + assets/

### **Step 4: Build Admin Dashboard** ✅
```bash
cd admin-dashboard
npm install
npm run build
```
**Result**:
- Build successful
- Output: `admin-dashboard/dist/` folder created
- Size: 424.62 kB (gzipped: 102.59 kB)
- Files: index.html + assets/

### **Step 5: Connect to VPS** ✅
```bash
ssh root@51.75.143.218
```
**Result**: Successfully connected to VPS

---

## 🔄 Current Step (In Progress)

### **Step 6: Check Current VPS Setup**

**Commands to run:**
```bash
ls -la /var/www/
docker ps
curl http://localhost:3001/health
```

**Status**: Waiting for output to assess current VPS state

---

## 📝 Code Changes Made Today

### **1. Vite Configuration Updates**

**File**: `vite.config.ts` (Customer Shop)
```typescript
export default defineConfig({
  plugins: [react()],
  base: '/customer/', // Added for subdirectory serving
  // ... rest of config
})
```

**File**: `admin-dashboard/vite.config.ts` (Admin Dashboard)
```typescript
export default defineConfig({
  plugins: [react()],
  base: '/admin/', // Added for subdirectory serving
  // ... rest of config
})
```

### **2. Environment Files Created**

**File**: `.env.production.example`
```env
VITE_API_URL=https://www.catalogquienquillerie.sqb-tunisie.com/api
```

**File**: `admin-dashboard/.env.production.example`
```env
VITE_API_URL=https://www.catalogquienquillerie.sqb-tunisie.com/api
```

### **3. Documentation Created**

- ✅ `VPS_DOMAIN_SETUP.md` - Complete nginx configuration guide
- ✅ `MANUAL_DEPLOYMENT_CHECKLIST.md` - Step-by-step deployment guide
- ✅ `deploy-to-vps.sh` - Automated deployment script (optional)
- ✅ `VPS_SAFE_UPDATE_ROADMAP.md` - Updated with Netlify context

---

## 📦 Built Files Ready for Upload

### **Customer Shop:**
- **Location**: `SmartCatalogueproject/dist/`
- **Size**: 289 KB
- **Target on VPS**: `/var/www/sqb-tunisie/customer/`

### **Admin Dashboard:**
- **Location**: `SmartCatalogueproject/admin-dashboard/dist/`
- **Size**: 424 KB
- **Target on VPS**: `/var/www/sqb-tunisie/admin/`

---

## 🎯 Next Steps (To Do)

### **Immediate:**
1. ⏳ Check current VPS directory structure
2. ⏳ Verify backend is running
3. ⏳ Create target directories on VPS
4. ⏳ Upload customer shop dist files
5. ⏳ Upload admin dashboard dist files

### **Backend Configuration:**
6. ⏳ Update backend `.env` CORS settings
7. ⏳ Verify backend API is accessible
8. ⏳ Restart backend if needed

### **Nginx Configuration:**
9. ⏳ Configure nginx for `/admin` path
10. ⏳ Configure nginx for `/customer` path
11. ⏳ Test nginx configuration
12. ⏳ Reload nginx

### **SSL & Testing:**
13. ⏳ Setup SSL certificates (if not done)
14. ⏳ Test admin dashboard in browser
15. ⏳ Test customer shop in browser
16. ⏳ Verify API connectivity
17. ⏳ Check for CORS errors

---

## 🔧 Technical Details

### **VPS Information:**
- **IP**: 51.75.143.218
- **User**: root
- **Backend Port**: 3001
- **Backend Container**: Docker

### **Required CORS Configuration:**
```env
CORS_ORIGIN=https://sqb-tunisie.com,https://www.sqb-tunisie.com,https://www.catalogquienquillerie.sqb-tunisie.com
```

### **Nginx Configuration Needed:**
```nginx
# Admin Dashboard
location /admin {
    alias /var/www/sqb-tunisie/admin;
    try_files $uri $uri/ /admin/index.html;
}

# Customer Shop
location /customer {
    alias /var/www/sqb-tunisie/customer;
    try_files $uri $uri/ /customer/index.html;
}
```

---

## 📚 Reference Documents

All documentation is in the project root:
- `VPS_DOMAIN_SETUP.md` - Complete setup guide
- `MANUAL_DEPLOYMENT_CHECKLIST.md` - Quick checklist
- `VPS_SAFE_UPDATE_ROADMAP.md` - Update procedures
- `QUICK_UPDATE_GUIDE_NETLIFY.md` - (Now outdated, kept for reference)

---

## 🚨 Important Notes

1. **Base Path**: Both apps configured with base paths (`/admin` and `/customer`)
2. **API URL**: All API calls point to `www.catalogquienquillerie.sqb-tunisie.com`
3. **Manual Deployment**: User prefers manual steps over automated script
4. **Step-by-Step**: Wait for confirmation after each step before proceeding
5. **Error Handling**: User will report errors immediately for troubleshooting

---

## 💾 Git Commits Made

### **Commit 1**: `5ff52f5`
```
feat: Configure for VPS deployment with custom domains (sqb-tunisie.com)

- Add base paths to Vite configs (/admin and /customer)
- Create production environment templates
- Add VPS domain setup documentation
- Add manual deployment checklist
- Add automated deployment script
- Remove Netlify dependency
```

**Files Changed**: 7 files, 886 insertions, 1 deletion

---

## 🔄 Session Resume Instructions

**To continue this session:**

1. Review this document
2. Check "Current Step (In Progress)" section
3. Continue from "Next Steps (To Do)" section
4. Reference "Technical Details" for configuration values
5. Use "Reference Documents" for detailed guides

**Current blocker**: Waiting for VPS directory structure output to proceed

---

**Last Updated**: November 15, 2025, 7:31 PM UTC+01:00  
**Session Status**: PAUSED - Waiting for VPS inspection results  
**Next Action**: Get output from VPS commands to assess current state
