import { Router } from 'express';
import {
  getAllCategories,
  getCategoryById,
  getSubcategories,
  createCategory,
  updateCategory,
  deleteCategory,
  getCategoryProducts,
} from '../controllers/category.controller';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth';

const router = Router();

// Public routes (no authentication required)
router.get('/', getAllCategories);
router.get('/:id', getCategoryById);
router.get('/:parentId/subcategories', getSubcategories);
router.get('/:id/products', getCategoryProducts);

// Protected routes (admin only)
router.post('/', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), createCategory);
router.put('/:id', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), updateCategory);
router.delete('/:id', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), deleteCategory);

export default router;
