import { useCart } from '../context/CartContext';

export default function CartDebugButton() {
  const { debugClearCart, debugLogCart, cartItems } = useCart();

  // Only show in development or if there are items in cart
  if (process.env.NODE_ENV === 'production' && cartItems.length === 0) {
    return null;
  }

  return (
    <div className="fixed bottom-4 right-4 z-50">
      <div className="bg-red-600 text-white p-2 rounded-lg shadow-lg">
        <div className="text-xs font-bold mb-2">Cart Debug</div>
        <button
          onClick={debugLogCart}
          className="block w-full text-xs bg-blue-600 hover:bg-blue-700 px-2 py-1 rounded mb-1"
        >
          Log Cart
        </button>
        <button
          onClick={debugClearCart}
          className="block w-full text-xs bg-red-800 hover:bg-red-900 px-2 py-1 rounded"
        >
          Clear Cart
        </button>
        <div className="text-xs mt-1 text-center">
          Items: {cartItems.length}
        </div>
      </div>
    </div>
  );
}
